package com.ejie.ab04b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VdesestimadosAperturas;

/**
 * VdesestimadosAperturasDaoImpl generated by UDA, 04-ago-2017 12:42:35.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VdesestimadosAperturasDaoImpl
		implements VdesestimadosAperturasDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VdesestimadosAperturas> rwMap = new RowMapper<VdesestimadosAperturas>() {
		public VdesestimadosAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdesestimadosAperturas(resultSet.getString("ANOEXP"),
					resultSet.getString("TERRITEXP"),
					resultSet.getInt("NUMEXP"), resultSet.getDate("REQFECHA"));
		}
	};

	private RowMapper<VdesestimadosAperturas> rwMapPK = new RowMapper<VdesestimadosAperturas>() {
		public VdesestimadosAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdesestimadosAperturas(resultSet.getString("ANOEXP"),
					resultSet.getString("TERRITEXP"),
					resultSet.getInt("NUMEXP"), resultSet.getDate("REQFECHA"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * dataSource DataSource
	 * 
	 */
	private RowMapper<JerarquiaDto<VdesestimadosAperturas>> rwMapJerarquia = new RowMapper<JerarquiaDto<VdesestimadosAperturas>>() {
		public JerarquiaDto<VdesestimadosAperturas> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			VdesestimadosAperturas vdesestimadosaperturas = new VdesestimadosAperturas(
					resultSet.getString("ANOEXP"),
					resultSet.getString("TERRITEXP"),
					resultSet.getInt("NUMEXP"), resultSet.getDate("REQFECHA"));

			JerarquiaDto<VdesestimadosAperturas> jerarquia = new JerarquiaDto<VdesestimadosAperturas>();
			jerarquia.setModel(vdesestimadosaperturas);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(
					Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(
					Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 *
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VdesestimadosAperturas table.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas VdesestimadosAperturas
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @return the vdesestimados aperturas
	 */
	public VdesestimadosAperturas add(
			VdesestimadosAperturas vdesestimadosaperturas) {
		String query = "INSERT INTO VDESESTIMADOS_APERTURAS (ANO_EXP, TERRIT_EXP, NUM_EXP, REQ_FECHA) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, vdesestimadosaperturas.getAnoExp(),
				vdesestimadosaperturas.getTerritExp(),
				vdesestimadosaperturas.getNumExp(),
				vdesestimadosaperturas.getReqFecha());
		return vdesestimadosaperturas;
	}

	/**
	 * Updates a single row in the VdesestimadosAperturas table.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas VdesestimadosAperturas
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @return the vdesestimados aperturas
	 */
	public VdesestimadosAperturas update(
			VdesestimadosAperturas vdesestimadosaperturas) {
		String query = "UPDATE VDESESTIMADOS_APERTURAS SET  WHERE ANO_EXP=? AND TERRIT_EXP=? AND NUM_EXP=? AND REQ_FECHA=?";
		this.jdbcTemplate.update(query, vdesestimadosaperturas.getAnoExp(),
				vdesestimadosaperturas.getTerritExp(),
				vdesestimadosaperturas.getNumExp(),
				vdesestimadosaperturas.getReqFecha());
		return vdesestimadosaperturas;
	}

	/**
	 * Finds a single row in the VdesestimadosAperturas table.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas VdesestimadosAperturas
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @return the vdesestimados aperturas
	 */
	@Transactional(readOnly = true)
	public VdesestimadosAperturas find(
			VdesestimadosAperturas vdesestimadosaperturas) {
		String query = "SELECT t1.ANO_EXP ANOEXP, t1.TERRIT_EXP TERRITEXP, t1.NUM_EXP NUMEXP, t1.REQ_FECHA REQFECHA FROM VDESESTIMADOS_APERTURAS t1  WHERE t1.ANO_EXP = ?   AND t1.TERRIT_EXP = ?   AND t1.NUM_EXP = ?   AND t1.REQ_FECHA = ?  ";

		List<VdesestimadosAperturas> vdesestimadosaperturasList = this.jdbcTemplate
				.query(query, this.rwMap, vdesestimadosaperturas.getAnoExp(),
						vdesestimadosaperturas.getTerritExp(),
						vdesestimadosaperturas.getNumExp(),
						vdesestimadosaperturas.getReqFecha());
		return (VdesestimadosAperturas) DataAccessUtils
				.uniqueResult(vdesestimadosaperturasList);
	}

	/**
	 * Removes a single row in the VdesestimadosAperturas table.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 */
	public void remove(VdesestimadosAperturas vdesestimadosaperturas) {
		String query = "DELETE FROM VDESESTIMADOS_APERTURAS WHERE ANO_EXP=? AND TERRIT_EXP=? AND NUM_EXP=? AND REQ_FECHA=?";
		this.jdbcTemplate.update(query, vdesestimadosaperturas.getAnoExp(),
				vdesestimadosaperturas.getTerritExp(),
				vdesestimadosaperturas.getNumExp(),
				vdesestimadosaperturas.getReqFecha());
	}

	/**
	 * Finds a list of rows in the VdesestimadosAperturas table.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas jqGridRequestDto
	 * JQGridRequestDto List<VdesestimadosAperturas>
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdesestimadosAperturas> findAll(
			VdesestimadosAperturas vdesestimadosaperturas,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		query.append("FROM VDESESTIMADOS_APERTURAS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdesestimadosaperturas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdesestimadosAperturas>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VdesestimadosAperturas table using like.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<VdesestimadosAperturas>
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdesestimadosAperturas> findAllLike(
			VdesestimadosAperturas vdesestimadosaperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANOAPE_056 ANOEXP,t1.TERAPE_056 TERRITEXP,t1.NUMAPE_056 NUMEXP,t1.FECREQ_056 REQFECHA ");
		query.append("FROM AB0456T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdesestimadosaperturas,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE IND_BATCH_SUB_056=1");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdesestimadosAperturas>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VdesestimadosAperturas table.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas Long
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VdesestimadosAperturas vdesestimadosaperturas) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0456T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdesestimadosaperturas);
		StringBuilder where = new StringBuilder(" WHERE IND_BATCH_SUB_056=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VdesestimadosAperturas table using like.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas startsWith Boolean Long
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VdesestimadosAperturas vdesestimadosaperturas,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0456T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdesestimadosaperturas,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE IND_BATCH_SUB_056=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VdesestimadosAperturas selected for rup_table.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto
	 * <VdesestimadosAperturas>>
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdesestimadosAperturas>> reorderSelection(
			VdesestimadosAperturas vdesestimadosaperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		// FROM
		query.append("FROM VDESESTIMADOS_APERTURAS t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdesestimadosaperturas,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, VdesestimadosAperturas.class,
				filterParamList, "ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VdesestimadosAperturas>(
						this.rwMapPK, jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams VdesestimadosAperturas searchParams VdesestimadosAperturas
	 * jqGridRequestDto JQGridRequestDto startsWith Boolean List<TableRowDto
	 * <VdesestimadosAperturas>>
	 *
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdesestimadosAperturas>> search(
			VdesestimadosAperturas filterParams,
			VdesestimadosAperturas searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		// FROM
		query.append("FROM VDESESTIMADOS_APERTURAS t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, VdesestimadosAperturas.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VdesestimadosAperturas>(
						this.rwMapPK, jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filtervdesestimadosaperturas VdesestimadosAperturas jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean
	 *
	 * @param filtervdesestimadosaperturas
	 *            the filtervdesestimadosaperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(
			VdesestimadosAperturas filtervdesestimadosaperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		// FROM
		query.append("FROM VDESESTIMADOS_APERTURAS t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this
				.getWhereLikeMap(filtervdesestimadosaperturas, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						VdesestimadosAperturas.class, query, params,
						"ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical VdesestimadosAperturas table.
	 * 
	 * filterVdesestimadosAperturas VdesestimadosAperturas jqGridRequestDto
	 * JQGridRequestDto List<JerarquiaDto<VdesestimadosAperturas>>
	 *
	 * @param filterVdesestimadosAperturas
	 *            the filter vdesestimados aperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<VdesestimadosAperturas>> findAllLikeJerarquia(
			VdesestimadosAperturas filterVdesestimadosAperturas,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANO_EXP ANOEXP,t1.TERRIT_EXP TERRITEXP,t1.NUM_EXP NUMEXP,t1.REQ_FECHA REQFECHA ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM VDESESTIMADOS_APERTURAS t1 ");
		List<String> from = new ArrayList<String>();
		from.add("VDESESTIMADOS_APERTURAS");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterVdesestimadosAperturas, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 * filterVdesestimadosAperturas VdesestimadosAperturas jqGridRequestDto
	 * JQGridRequestDto Long
	 *
	 * @param filterVdesestimadosAperturas
	 *            the filter vdesestimados aperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(
			VdesestimadosAperturas filterVdesestimadosAperturas,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM VDESESTIMADOS_APERTURAS t1 ");
		List<String> from = new ArrayList<String>();
		from.add("VDESESTIMADOS_APERTURAS");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterVdesestimadosAperturas, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere,
				"ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 * filterVdesestimadosAperturas VdesestimadosAperturas jqGridRequestDto
	 * JQGridRequestDto List<TableRowDto<VdesestimadosAperturas>>
	 *
	 * @param filterVdesestimadosAperturas
	 *            the filter vdesestimados aperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdesestimadosAperturas>> findAllChild(
			VdesestimadosAperturas filterVdesestimadosAperturas,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM VDESESTIMADOS_APERTURAS t1 ");
		List<String> from = new ArrayList<String>();
		from.add("VDESESTIMADOS_APERTURAS");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterVdesestimadosAperturas, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere,
				"ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<VdesestimadosAperturas>(
						this.rwMapPK, "ANO_EXP,TERRIT_EXP,NUM_EXP,REQ_FECHA"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdesestimadosAperturas entity.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas Bean with the criteria
	 * values to filter by. Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			VdesestimadosAperturas vdesestimadosaperturas) {

		StringBuilder where = new StringBuilder(
				VdesestimadosAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdesestimadosaperturas != null
				&& vdesestimadosaperturas.getAnoExp() != null) {
			where.append(" AND t1.ANOAPE_056 = ?");
			params.add(vdesestimadosaperturas.getAnoExp());
		}
		if (vdesestimadosaperturas != null
				&& vdesestimadosaperturas.getTerritExp() != null) {
			where.append(" AND t1.TERAPE_056 = ?");
			params.add(vdesestimadosaperturas.getTerritExp());
		}
		if (vdesestimadosaperturas != null
				&& vdesestimadosaperturas.getNumExp() != null) {
			where.append(" AND t1.NUMAPE_056 = ?");
			params.add(vdesestimadosaperturas.getNumExp());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdesestimadosAperturas entity.
	 * 
	 * vdesestimadosaperturas VdesestimadosAperturas Bean with the criteria
	 * values to filter by. startsWith Boolean Map created with two keys key
	 * query stores the sql query syntax key params stores the parameter values
	 * to be used in the condition sentence.
	 *
	 * @param vdesestimadosaperturas
	 *            the vdesestimadosaperturas
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			VdesestimadosAperturas vdesestimadosaperturas, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VdesestimadosAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdesestimadosaperturas != null
				&& vdesestimadosaperturas.getAnoExp() != null) {
			where.append(" AND UPPER(t1.ANOAPE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vdesestimadosaperturas.getAnoExp().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vdesestimadosaperturas.getAnoExp().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.ANOAPE_056 IS NOT NULL");
		}
		if (vdesestimadosaperturas != null
				&& vdesestimadosaperturas.getTerritExp() != null) {
			where.append(" AND UPPER(t1.TERAPE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdesestimadosaperturas.getTerritExp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vdesestimadosaperturas.getTerritExp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TERAPE_056 IS NOT NULL");
		}
		if (vdesestimadosaperturas != null
				&& vdesestimadosaperturas.getNumExpDesde() != null) {
			where.append(" AND t1.NUMAPE_056 >= ?");
			params.add(vdesestimadosaperturas.getNumExpDesde());
		}
		if (vdesestimadosaperturas != null
				&& vdesestimadosaperturas.getNumExpHasta() != null) {
			where.append(" AND t1.NUMAPE_056 <= ?");
			params.add(vdesestimadosaperturas.getNumExpHasta());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
